/*
 * Decompiled with CFR 0.152.
 */
package emotions;

import emotions.Emotion;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class BodilyMapPanel
extends JPanel {
    private BufferedImage[] images;
    private Emotion emotion;
    public static int WIDTH_IMG = 80;
    public static int HEIGHT_IMG = 240;
    public static String FOLDER_IMG = "img/";
    public static String EXTENSION_IMG = ".jpg";

    public BodilyMapPanel() {
        this.loadImages();
        this.setEmotion(Emotion.NEUTRAL);
    }

    public void loadImages() {
        int numEmotions = Emotion.values().length;
        this.images = new BufferedImage[numEmotions];
        int count = 0;
        for (Emotion emotion : Emotion.values()) {
            System.out.println((Object)emotion);
            try {
                String path = FOLDER_IMG + emotion.name() + EXTENSION_IMG;
                this.images[count] = ImageIO.read(new File(path));
                System.out.println("Img loaded properly");
            }
            catch (IOException e) {
                System.out.println("Error loading file:" + e.getMessage());
            }
            ++count;
        }
    }

    public void setEmotion(Emotion emotion) {
        this.emotion = emotion;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.images[this.emotion.ordinal()], 0, 0, null);
    }
}

