/*
 * Decompiled with CFR 0.152.
 */
package mindfulness;

import emotions.BodilyMapGUI;
import emotions.Emotion;
import emotions.EmotionUtils;
import emotions.OrtogonalEmotion;
import instructor.InstructorAgent;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import mindfulness.PractitionerAgent;
import simulation.Agent;
import simulation.Simulation;

public class MainGUI
extends JFrame {
    private BodilyMapGUI mapGUI = null;
    private PractitionerAgent practitioner;
    private Simulation simulation;
    private int numSimulations;
    private int contSim;
    private double[][] results;
    private double[][] summary;
    private JFileChooser chooser;
    public static int NUM_SUMMARIES = 2;
    public static final Charset ENCODING = StandardCharsets.ISO_8859_1;
    public static final int COLUMN_LENGTH = 15;
    private ButtonGroup buttonGroupStrategy;
    private JButton jButtonRunSimulation;
    private JComboBox jComboBoxInstructor;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelCouple;
    private JLabel jLabelFamilyBabies;
    private JLabel jLabelInput1;
    private JLabel jLabelTrips;
    private JRadioButton jRadioButtonDefaultStrategy;
    private JRadioButton jRadioButtonNewPlan;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTable jTable1;
    private JTable jTableResults;
    private JTable jTableSummary;
    private JTextField jTextFieldInitialAnger;
    private JTextField jTextFieldInitialAnxiety;
    private JTextField jTextFieldInitialDepression;
    private JTextField jTextFieldIterations;
    private JTextField jTextFieldNumPractitioners;
    private JTextField jTextFieldPlan;

    public MainGUI() {
        this.initComponents();
        this.initOtherComponents();
        this.mapGUI = new BodilyMapGUI();
        this.mapGUI.setLocation(this.getWidth(), 0);
        this.mapGUI.setVisible(true);
        this.summary = new double[NUM_SUMMARIES][OrtogonalEmotion.values().length];
    }

    private void performMindfulnesssSimulation() {
        this.simulation = new Simulation();
        this.createPractitionerAgents();
        this.createInstructorAgent();
        this.simulation.run(this.readIterations());
        this.showResults();
    }

    private void createPractitionerAgents() {
        int numPractitioners = this.readPractitioners();
        for (int i = 0; i < numPractitioners; ++i) {
            this.createPractitionerAgent();
        }
    }

    private void createPractitionerAgent() {
        this.practitioner = new PractitionerAgent();
        double value = Double.parseDouble(this.jTextFieldInitialAnger.getText());
        this.practitioner.setFeeling(OrtogonalEmotion.ANGER, value);
        value = Double.parseDouble(this.jTextFieldInitialAnxiety.getText());
        this.practitioner.setFeeling(OrtogonalEmotion.ANXIETY, value);
        value = Double.parseDouble(this.jTextFieldInitialDepression.getText());
        this.practitioner.setFeeling(OrtogonalEmotion.DEPRESSION, value);
        this.simulation.register(this.practitioner);
    }

    public void createInstructorAgent() {
        String strInstructor = "";
        InstructorAgent instructor = null;
        Class<?> instructorSubclass = null;
        if (this.jRadioButtonDefaultStrategy.getModel().isSelected()) {
            strInstructor = (String)this.jComboBoxInstructor.getSelectedItem();
        } else if (this.jRadioButtonNewPlan.getModel().isSelected()) {
            strInstructor = this.jTextFieldPlan.getText();
        }
        try {
            if (!strInstructor.equals("Omitted") && !strInstructor.equals("")) {
                instructorSubclass = Class.forName("instructor." + strInstructor);
                Constructor<?> constructor = instructorSubclass.getConstructor(Simulation.class);
                instructor = (InstructorAgent)constructor.newInstance(this.simulation);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "The instructor plan \"" + strInstructor + "\"has not been found, \n" + "so there will not be any instructor agent in the simulation. \n" + "If you are willing to do it so, the next time make sure \n" + "you appropriately compile it in the teacher package and \n" + "introduce its class name (case sensitive) in the field. \n");
        }
        if (instructor != null) {
            this.simulation.register(instructor);
        }
    }

    private void showResults() {
        Emotion predominantEmotion = this.practitioner.obtainPredominantEmotion();
        this.mapGUI.setEmotion(predominantEmotion);
        this.changeSizeJTableResults(this.readPractitioners());
        this.results = new double[this.readPractitioners()][OrtogonalEmotion.values().length];
        int row = 0;
        for (Agent agent : this.simulation.getAgents()) {
            if (!(agent instanceof PractitionerAgent)) continue;
            this.practitioner = (PractitionerAgent)agent;
            for (OrtogonalEmotion emotion : OrtogonalEmotion.values()) {
                this.results[row][emotion.ordinal()] = this.practitioner.getFeeling(emotion);
            }
            this.printEmotionResults(this.practitioner, row);
            ++row;
        }
        this.calculateSummary();
        this.showSummary();
        System.out.println(this.simulation);
    }

    public void printEmotionResults(PractitionerAgent practitioner, int row) {
        for (OrtogonalEmotion emotion : OrtogonalEmotion.values()) {
            this.jTableResults.getModel().setValueAt("" + (row + 1), row, 0);
            this.jTableResults.getModel().setValueAt(EmotionUtils.EMOTION_FORMAT.format(practitioner.getFeeling(emotion)), row, emotion.ordinal() + 1);
        }
    }

    private int readIterations() {
        return Integer.parseInt(this.jTextFieldIterations.getText());
    }

    private int readPractitioners() {
        return Integer.parseInt(this.jTextFieldNumPractitioners.getText());
    }

    public void initOtherComponents() {
        this.chooser = new JFileChooser();
        this.buttonGroupStrategy.add(this.jRadioButtonDefaultStrategy);
        this.buttonGroupStrategy.add(this.jRadioButtonNewPlan);
        this.buttonGroupStrategy.setSelected(this.jRadioButtonDefaultStrategy.getModel(), true);
    }

    public void calculateSummary() {
        int i;
        int j;
        int numMetrics = OrtogonalEmotion.values().length;
        int indexAvrg = 0;
        for (int i2 = 0; i2 < numMetrics; ++i2) {
            this.summary[indexAvrg][i2] = 0.0;
        }
        int numPractitioners = this.readPractitioners();
        for (int i3 = 0; i3 < numPractitioners; ++i3) {
            for (j = 0; j < numMetrics; ++j) {
                this.summary[indexAvrg][j] = this.summary[indexAvrg][j] + this.results[i3][j];
            }
        }
        for (int j2 = 0; j2 < numMetrics; ++j2) {
            this.summary[indexAvrg][j2] = this.summary[indexAvrg][j2] / (double)numPractitioners;
        }
        int indexSD = 1;
        for (i = 0; i < numMetrics; ++i) {
            this.summary[indexSD][i] = 0.0;
        }
        for (i = 0; i < numPractitioners; ++i) {
            for (int j3 = 0; j3 < numMetrics; ++j3) {
                double diff = this.results[i][j3] - this.summary[indexAvrg][j3];
                double square = Math.pow(diff, 2.0);
                this.summary[indexSD][j3] = this.summary[indexSD][j3] + square;
            }
        }
        for (j = 0; j < numMetrics; ++j) {
            this.summary[indexSD][j] = this.summary[indexSD][j] / (double)numPractitioners;
            this.summary[indexSD][j] = Math.sqrt(this.summary[indexSD][j]);
        }
    }

    public void showSummary() {
        this.jTableSummary.setValueAt("Average", 0, 0);
        this.jTableSummary.setValueAt("SD", 1, 0);
        for (int i = 0; i < NUM_SUMMARIES; ++i) {
            for (int j = 0; j < OrtogonalEmotion.values().length; ++j) {
                this.jTableSummary.setValueAt(EmotionUtils.EMOTION_FORMAT.format(this.summary[i][j]), i, j + 1);
            }
        }
    }

    public void saveJTable(JTable jtable, PrintStream out, int numRows) {
        String str;
        int i;
        for (i = 0; i < jtable.getModel().getColumnCount(); ++i) {
            str = jtable.getModel().getColumnName(i);
            str = String.format("%1$15s", str);
            out.print(str + "\t");
        }
        out.println();
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < jtable.getModel().getColumnCount(); ++j) {
                str = (String)jtable.getValueAt(i, j);
                str = String.format("%1$15s", str);
                out.print(str + "\t");
            }
            out.println();
        }
    }

    public void changeSizeJTableResults(int numRows) {
        Object[] titles = new String[]{"Id. Practitioner", "Anger", "Anxiety", "Depression"};
        Object[][] objects = new Object[numRows][titles.length];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < titles.length; ++j) {
                objects[i][j] = null;
            }
        }
        this.jTableResults.setModel(new DefaultTableModel(objects, titles){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTableResults);
    }

    public void clearJTableSummary() {
        int numMetrics = OrtogonalEmotion.values().length;
        for (int i = 0; i < NUM_SUMMARIES; ++i) {
            for (int j = 0; j < numMetrics + 1; ++j) {
                this.jTableSummary.setValueAt("", i, j);
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.buttonGroupStrategy = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.jTextFieldInitialAnger = new JTextField();
        this.jLabelCouple = new JLabel();
        this.jTextFieldInitialAnxiety = new JTextField();
        this.jLabelFamilyBabies = new JLabel();
        this.jTextFieldInitialDepression = new JTextField();
        this.jLabelTrips = new JLabel();
        this.jTextFieldIterations = new JTextField();
        this.jLabelInput1 = new JLabel();
        this.jButtonRunSimulation = new JButton();
        this.jTextFieldNumPractitioners = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableResults = new JTable();
        this.jScrollPane3 = new JScrollPane();
        this.jTableSummary = new JTable();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jComboBoxInstructor = new JComboBox();
        this.jRadioButtonDefaultStrategy = new JRadioButton();
        this.jRadioButtonNewPlan = new JRadioButton();
        this.jTextFieldPlan = new JTextField();
        this.jLabel1.setText("jLabel1");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.setDefaultCloseOperation(3);
        this.setTitle("ABSEM (an ABS of Emotions in Mindfulness programs)");
        this.jLabel2.setText("Initial Anger:");
        this.jTextFieldInitialAnger.setText("0.12000");
        this.jTextFieldInitialAnger.setToolTipText("");
        this.jTextFieldInitialAnger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jTextFieldInitialAngerActionPerformed(evt);
            }
        });
        this.jLabelCouple.setText("Initial Anxiety:");
        this.jTextFieldInitialAnxiety.setText("0.15952");
        this.jTextFieldInitialAnxiety.setToolTipText("");
        this.jTextFieldInitialAnxiety.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jTextFieldInitialAnxietyActionPerformed(evt);
            }
        });
        this.jLabelFamilyBabies.setText("Initial Depression:");
        this.jTextFieldInitialDepression.setText("0.19762");
        this.jTextFieldInitialDepression.setToolTipText("");
        this.jTextFieldInitialDepression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jTextFieldInitialDepressionActionPerformed(evt);
            }
        });
        this.jLabelTrips.setText("Number of Sessions:");
        this.jTextFieldIterations.setText("8");
        this.jTextFieldIterations.setToolTipText("");
        this.jTextFieldIterations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jTextFieldIterationsActionPerformed(evt);
            }
        });
        this.jLabelInput1.setFont(new Font("Tahoma", 1, 14));
        this.jLabelInput1.setText("Parameters of the Simulation");
        this.jLabelInput1.setToolTipText("");
        this.jButtonRunSimulation.setText("Run Simulation");
        this.jButtonRunSimulation.setToolTipText("");
        this.jButtonRunSimulation.setActionCommand("RunSimulation");
        this.jButtonRunSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.runSimulationActionPerformed(evt);
            }
        });
        this.jTextFieldNumPractitioners.setText("21");
        this.jTextFieldNumPractitioners.setToolTipText("");
        this.jTextFieldNumPractitioners.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jTextFieldNumPractitionersActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Number of Practitioners:");
        this.jLabel6.setFont(new Font("Tahoma", 1, 14));
        this.jLabel6.setText("Results");
        this.jTableResults.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Id. Simulation", "Anger", "Anxiety", "Depression", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTableResults);
        this.jTableSummary.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"", "Anger", "Anxiety", "Depression", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane3.setViewportView(this.jTableSummary);
        this.jLabel7.setFont(new Font("Tahoma", 1, 14));
        this.jLabel7.setText("Summary of the Results");
        this.jLabel8.setFont(new Font("Tahoma", 1, 14));
        this.jLabel8.setText("Mindfulness Program:");
        this.jLabel8.setToolTipText("");
        this.jComboBoxInstructor.setModel(new DefaultComboBoxModel<String>(new String[]{"Omitted", "Wongtongkam", "Song"}));
        this.jComboBoxInstructor.setSelectedIndex(2);
        this.jComboBoxInstructor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jComboBoxInstructorActionPerformed(evt);
            }
        });
        this.jRadioButtonDefaultStrategy.setSelected(true);
        this.jRadioButtonDefaultStrategy.setText("Default Program");
        this.jRadioButtonDefaultStrategy.setToolTipText("");
        this.jRadioButtonDefaultStrategy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jRadioButtonDefaultStrategyActionPerformed(evt);
            }
        });
        this.jRadioButtonNewPlan.setText("User Program");
        this.jRadioButtonNewPlan.setToolTipText("");
        this.jRadioButtonNewPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.jRadioButtonNewPlanActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addComponent(this.jLabelCouple, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelFamilyBabies).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelTrips)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldInitialAnxiety).addComponent(this.jTextFieldInitialAnger).addComponent(this.jTextFieldInitialDepression).addComponent(this.jTextFieldNumPractitioners).addComponent(this.jTextFieldIterations))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonRunSimulation).addComponent(this.jRadioButtonNewPlan).addComponent(this.jRadioButtonDefaultStrategy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxInstructor, 0, 123, Short.MAX_VALUE).addComponent(this.jTextFieldPlan))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabelInput1)).addGap(0, 0, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6).addComponent(this.jScrollPane1, -2, 452, -2).addComponent(this.jScrollPane3, -2, -1, -2)).addGap(25, 25, 25)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelInput1).addComponent(this.jLabel6)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldInitialAnger, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCouple).addComponent(this.jTextFieldInitialAnxiety)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelFamilyBabies).addComponent(this.jTextFieldInitialDepression)).addGap(49, 49, 49).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldNumPractitioners, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTrips).addComponent(this.jTextFieldIterations, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 224, -2).addGap(18, 18, Short.MAX_VALUE))).addComponent(this.jLabel7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel8).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxInstructor, -2, -1, -2).addComponent(this.jRadioButtonDefaultStrategy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonNewPlan).addComponent(this.jTextFieldPlan, -2, -1, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jScrollPane3, -2, 93, -2))).addGap(1, 1, 1).addComponent(this.jButtonRunSimulation).addContainerGap()));
        this.pack();
    }

    private void jTextFieldInitialAngerActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldInitialAnxietyActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldInitialDepressionActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldIterationsActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldNumPractitionersActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxInstructorActionPerformed(ActionEvent evt) {
    }

    private void jRadioButtonDefaultStrategyActionPerformed(ActionEvent evt) {
    }

    private void jRadioButtonNewPlanActionPerformed(ActionEvent evt) {
    }

    private void runSimulationActionPerformed(ActionEvent evt) {
        this.performMindfulnesssSimulation();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainGUI().setVisible(true);
            }
        });
    }
}

