/*
 * Decompiled with CFR 0.152.
 */
package mindfulness;

import deck.DeckRandom;
import emotions.OrtogonalEmotion;
import mindfulness.Practice;
import mindfulness.PractitionerAgent;

public class MindfulnessKnowledge {
    private double[][] proportionalInfluence;
    private double[][] incrementalInfluence;
    private DeckRandom progressDeck;
    private int progressValue = 90;
    private int progressSize = 100;
    private int limitAgentsProgress = 2;
    private static final double DEFAULT_PROPORTION = -0.2;
    private static final double DEFAULT_INCREMENT = 0.0;

    public MindfulnessKnowledge() {
        int sizeEmotions = OrtogonalEmotion.values().length;
        int sizePractice = Practice.values().length;
        this.proportionalInfluence = new double[sizeEmotions][sizePractice];
        this.incrementalInfluence = new double[sizeEmotions][sizePractice];
        for (int i = 0; i < sizeEmotions; ++i) {
            for (int j = 0; j < sizePractice; ++j) {
                this.proportionalInfluence[i][j] = -0.2;
                this.incrementalInfluence[i][j] = 0.0;
            }
        }
        this.createKnownInfluences();
        this.progressDeck = new DeckRandom(this.progressValue, this.progressSize);
    }

    public void createKnownInfluences() {
        this.incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()][Practice.MINDUFL_MANTRAS.ordinal()] = -5.6E-6;
        this.incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()][Practice.MINDFUL_BREATHING.ordinal()] = -2.686E-4;
        this.incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()][Practice.CONSCIOUS_OBSERVATION.ordinal()] = -0.0011372;
        this.incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()][Practice.WALKING_MEDITATION.ordinal()] = -4.404E-4;
        this.incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()][Practice.LECTURE_BEHAVIOR_TOWARDS_OTHERS.ordinal()] = -9.054E-4;
        this.incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()][Practice.SITTING_MEDITATION.ordinal()] = -6.819E-4;
        this.incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()][Practice.MINDUFL_MANTRAS.ordinal()] = -6.0E-6;
        this.incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()][Practice.BODY_SCAN.ordinal()] = -0.0371257;
        this.incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()][Practice.BODY_SCAN.ordinal()] = -0.0265972;
        this.incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()][Practice.MINDFUL_EATING.ordinal()] = -0.0285857;
        this.incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()][Practice.MINDFUL_EATING.ordinal()] = -0.021417;
        this.incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()][Practice.MINDFUL_BREATHING.ordinal()] = -1.603E-4;
        this.incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()][Practice.MINDFUL_BREATHING.ordinal()] = -0.0013937;
        this.incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()][Practice.SITTING_MEDITATION.ordinal()] = -1.603E-4;
        this.incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()][Practice.SITTING_MEDITATION.ordinal()] = -0.0013937;
        this.incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()][Practice.WALKING_MEDITATION.ordinal()] = -3.683E-4;
        this.incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()][Practice.WALKING_MEDITATION.ordinal()] = -0.0027248;
        this.incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()][Practice.MINDFUL_MOVEMENT.ordinal()] = -0.0038289;
        this.incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()][Practice.MINDFUL_MOVEMENT.ordinal()] = -0.015786;
        this.incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()][Practice.MINDFULNESS_MEDITATION.ordinal()] = -0.0024908;
        this.incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()][Practice.MINDFULNESS_MEDITATION.ordinal()] = -0.0029012;
        this.incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()][Practice.MINDFULNESS_MEDITATION.ordinal()] = -0.0021431;
    }

    public void applyPracticeWhenProgress(PractitionerAgent practitioner, Practice practice, int numAgents) {
        if (numAgents <= this.limitAgentsProgress) {
            this.applyPractice(practitioner, practice);
        } else if (this.progressDeck.nextInt() == 1) {
            this.applyPractice(practitioner, practice);
        }
    }

    public void applyPractice(PractitionerAgent practitioner, Practice practice) {
        for (OrtogonalEmotion emotion : OrtogonalEmotion.values()) {
            double Fi = practitioner.getFeeling(emotion);
            double Dij = this.proportionalInfluence[emotion.ordinal()][practice.ordinal()];
            double Sij = this.incrementalInfluence[emotion.ordinal()][practice.ordinal()];
            double Aij = Dij * (1.0 - Math.abs(Fi));
            Fi = Math.abs(Aij) < Math.abs(Sij) ? (Fi += Aij) : (Fi += Sij);
            practitioner.setFeeling(emotion, Fi);
        }
    }
}

