/*
 * Decompiled with CFR 0.152.
 */
package mindfulness;

import emotions.Emotion;
import emotions.EmotionUtils;
import emotions.OrtogonalEmotion;
import simulation.Agent;

public class PractitionerAgent
implements Agent {
    private double[] feelings = new double[OrtogonalEmotion.values().length];

    public PractitionerAgent() {
        for (int i = 0; i < this.feelings.length; ++i) {
            this.feelings[i] = 0.0;
        }
    }

    public void setFeeling(OrtogonalEmotion emotion, double feelingValue) {
        this.feelings[emotion.ordinal()] = feelingValue;
    }

    public double getFeeling(OrtogonalEmotion emotion) {
        return this.feelings[emotion.ordinal()];
    }

    public Emotion obtainPredominantEmotion() {
        OrtogonalEmotion maxEmotion = OrtogonalEmotion.values()[0];
        double maxValue = Double.MIN_VALUE;
        for (OrtogonalEmotion emotion : OrtogonalEmotion.values()) {
            double valueAbs = Math.abs(this.feelings[emotion.ordinal()]);
            if (!(valueAbs > maxValue)) continue;
            maxValue = valueAbs;
            maxEmotion = emotion;
        }
        Emotion predominant = Emotion.NEUTRAL;
        if (maxValue > EmotionUtils.NEUTRAL_THRESHOLD) {
            predominant = this.feelings[maxEmotion.ordinal()] > 0.0 ? Emotion.valueOf(maxEmotion.toString()) : EmotionUtils.oppositeEmotion(maxEmotion);
        }
        return predominant;
    }

    public String toString() {
        String str = "PractitionerAgent(";
        for (int i = 0; i < this.feelings.length; ++i) {
            str = str + (Object)((Object)OrtogonalEmotion.values()[i]);
            str = str + ":" + this.feelings[i] + "; ";
        }
        str = str + ")";
        return str;
    }

    @Override
    public void live() {
    }
}

