/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import java.io.PrintStream;
import java.text.DecimalFormat;

public abstract class MeasurementEvolution {
    protected String[] metrics;
    private int numIterations;
    protected double[][] values;
    private static DecimalFormat METRIC_FORMAT = new DecimalFormat("#.00000");
    public static int COLUMN_LENGTH = 8;

    public MeasurementEvolution(int numIterations, int numMetrics) {
        this.numIterations = numIterations;
        this.values = new double[numIterations][numMetrics];
    }

    public abstract void recordValues();

    public void recordValues(int iteration, double[] valuesIter) {
        if (valuesIter.length > this.values.length) {
            System.out.println("Error in MeasurementEvolution:recordValues");
            return;
        }
        for (int metric = 0; metric < valuesIter.length; ++metric) {
            this.values[iteration][metric] = valuesIter[metric];
        }
    }

    public void saveValues(PrintStream out) {
        int i;
        out.println();
        out.println("EVOLUTION OF THE SOCIOMETRICS THROUGH THE ITERATIONS");
        String str = "Iteration";
        str = String.format("%1$" + COLUMN_LENGTH + "s", str);
        out.print(str + "\t");
        for (i = 0; i < this.metrics.length; ++i) {
            str = this.metrics[i];
            str = String.format("%1$" + COLUMN_LENGTH + "s", str);
            out.print(str + "\t");
        }
        out.println();
        for (i = 0; i < this.values.length; ++i) {
            str = "" + i;
            str = String.format("%1$" + COLUMN_LENGTH + "s", str);
            out.print(str + "\t");
            for (int j = 0; j < this.values[i].length; ++j) {
                str = METRIC_FORMAT.format(this.values[i][j]);
                str = String.format("%1$" + COLUMN_LENGTH + "s", str);
                out.print(str + "\t");
            }
            out.println();
        }
    }
}

