/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import java.util.LinkedList;
import java.util.List;
import simulation.Agent;

public class Simulation {
    private List<Agent> agents = new LinkedList<Agent>();
    private int iteration;

    public void register(Agent agent) {
        this.agents.add(agent);
    }

    public void live() {
        for (Agent agent : this.agents) {
            agent.live();
        }
    }

    public void run(int numIterations) {
        this.iteration = 0;
        while (this.iteration < numIterations) {
            this.live();
            ++this.iteration;
        }
    }

    public int getSize() {
        return this.agents.size();
    }

    public String toString() {
        String str = "Simulation with the following agents:\n";
        for (Agent agent : this.agents) {
            str = str + agent + "\n";
        }
        return str;
    }

    public List<Agent> getAgents() {
        return this.agents;
    }

    public int getIteration() {
        return this.iteration;
    }
}

