/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.Timer;
import simulation.MeasurementEvolution;
import simulation.ObserverAnimation;
import simulation.Simulation;

public class SimulationAnimation
extends Simulation {
    private Timer timer;
    private int time_interval;
    private JFrame gui;
    private int iteration;
    private int numIterations;
    private MeasurementEvolution measurement = null;
    private ObserverAnimation observer = null;

    public SimulationAnimation(JFrame paramGui) {
        this.gui = paramGui;
    }

    @Override
    public void run(int paramNumIterations) {
        this.numIterations = paramNumIterations;
        this.iteration = 0;
        this.timer = new Timer(this.time_interval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationAnimation.this.live();
                SimulationAnimation.this.gui.repaint();
                if (SimulationAnimation.this.measurement != null) {
                    SimulationAnimation.this.measurement.recordValues();
                }
                SimulationAnimation.this.run();
            }
        });
        this.timer.start();
    }

    public void run() {
        ++this.iteration;
        this.timer.stop();
        if (this.iteration < this.numIterations) {
            this.timer.start();
        } else {
            this.observer.updateFinishedSimulation();
        }
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setSpeed(double speed) {
        this.time_interval = (int)(1000.0 / speed);
    }

    public void setMeasurementEvolution(MeasurementEvolution measurement) {
        this.measurement = measurement;
    }

    public void setObserver(ObserverAnimation observer) {
        this.observer = observer;
    }
}

