/*
 * Decompiled with CFR 0.152.
 */
package deck;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

public class DeckRandom {
    private int[] cards;
    private int size;
    private int peek;
    private boolean autoReshuffling;
    private List<Integer> choices;
    private static boolean DEFAULT_AUTO_RESHUFFLING = true;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int FIRST_CHOICE = 1;
    public static final int SECOND_CHOICE = 2;
    public static final int THIRD_CHOICE = 3;

    public DeckRandom(List<Integer> choices, int size) {
        int i;
        this.cards = new int[size];
        this.size = size;
        this.peek = 0;
        this.autoReshuffling = DEFAULT_AUTO_RESHUFFLING;
        this.choices = choices;
        int intChoice = 1;
        ListIterator<Integer> it = choices.listIterator();
        int pos = 0;
        while (it.hasNext()) {
            Integer choiceJ = (Integer)it.next();
            for (i = 0; i < choiceJ && pos < size; ++pos, ++i) {
                this.cards[pos] = intChoice;
            }
            ++intChoice;
        }
        for (i = pos; i < size; ++i) {
            this.cards[i] = intChoice;
        }
        this.shuffle();
    }

    public DeckRandom(int choice1, int size) {
        this(DeckRandom.createListArgs(choice1), size);
    }

    private static List<Integer> createListArgs(int choice1) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        list.add(new Integer(choice1));
        return list;
    }

    public DeckRandom(int choice1, int choice2, int size) {
        this(DeckRandom.createListArgs(choice1, choice2), size);
    }

    private static List<Integer> createListArgs(int choice1, int choice2) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        list.add(new Integer(choice1));
        list.add(new Integer(choice2));
        return list;
    }

    public int nextInt() {
        int peekCard = this.cards[this.peek];
        this.peek = (this.peek + 1) % this.size;
        if (this.peek == 0 && this.autoReshuffling) {
            this.shuffle();
        }
        return peekCard;
    }

    public void shuffle() {
        Random generator = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.size; ++i) {
            int left = this.size - i;
            int random = generator.nextInt(left);
            int posSelected = i + random;
            int aux = this.cards[i];
            this.cards[i] = this.cards[posSelected];
            this.cards[posSelected] = aux;
        }
    }

    public String toString() {
        String str = "Deck (" + this.size + ")(";
        for (int choice : this.choices) {
            str = str + choice + ",";
        }
        str = str + ")";
        for (int i = 0; i < this.cards.length; ++i) {
            str = str + " " + this.cards[i];
        }
        return str;
    }

    public boolean isAutoReshuffling() {
        return this.autoReshuffling;
    }

    public void setAutoReshuffling(boolean autoReshuffling) {
        this.autoReshuffling = autoReshuffling;
    }
}

