/*
 * Decompiled with CFR 0.152.
 */
package trainingdeck;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import trainingdeck.CaseSim;
import trainingdeck.ObjectiveSim;
import trainingdeck.TrainableSim;

public class TrainerSim {
    private TrainableSim sim;
    private int maxIterations = 10;

    public TrainerSim(TrainableSim sim) {
        this.sim = sim;
    }

    public int trainDeck(String nameDeckChoice, int[] indexes, int sizeDeck, HashMap<String, Object> input, HashMap<String, Object> output, ObjectiveSim objective) {
        HashMap<String, Object> meanResult = null;
        int min = 0;
        int max = sizeDeck;
        boolean found = false;
        while (min < max && !found) {
            int mean = (max + min) / 2;
            this.sim.setDeckValue(nameDeckChoice, indexes, mean);
            meanResult = this.sim.runSimulation(input);
            if (objective.compare(output, meanResult) == 0.0) {
                min = mean;
                found = true;
                continue;
            }
            if (objective.compare(output, meanResult) > 0.0) {
                min = mean + 1;
                continue;
            }
            max = mean - 1;
        }
        int result = min;
        this.sim.setDeckValue(nameDeckChoice, indexes, result);
        double diff = Math.abs(objective.compare(output, this.sim.runSimulation(input)));
        this.sim.setDeckValue(nameDeckChoice, indexes, result - 1);
        double diffPrev = Math.abs(objective.compare(output, this.sim.runSimulation(input)));
        this.sim.setDeckValue(nameDeckChoice, indexes, result + 1);
        double diffNext = Math.abs(objective.compare(output, this.sim.runSimulation(input)));
        if (diffPrev < diff && diffPrev < diffNext) {
            --result;
        } else if (diffNext < diff && diffNext < diffPrev) {
            ++result;
        }
        if (result > sizeDeck) {
            result = sizeDeck;
        } else if (result < 0) {
            result = 0;
        }
        this.sim.setDeckValue(nameDeckChoice, indexes, result);
        return result;
    }

    public TrainableSim train(List<CaseSim> cases) {
        boolean stable = false;
        int[] learned = new int[cases.size()];
        for (int i = 0; i < learned.length; ++i) {
            learned[i] = -1;
        }
        for (int counterIt = 0; counterIt < this.maxIterations && !stable; ++counterIt) {
            Iterator<CaseSim> it = cases.iterator();
            int counterCases = 0;
            stable = true;
            while (it.hasNext()) {
                CaseSim c = it.next();
                this.trainDeck(c.getNameDeckChoice(), c.getIndexes(), c.getSizeDeck(), c.getInput(), c.getOutput(), c.getObjective());
                System.out.println(c.getNameDeckChoice() + c.getIndexes()[0] + c.getIndexes()[1] + ":" + this.sim.getDeckValue(c.getNameDeckChoice(), c.getIndexes()));
                int deckValue = this.sim.getDeckValue(c.getNameDeckChoice(), c.getIndexes());
                if (deckValue != learned[counterCases]) {
                    stable = false;
                }
                learned[counterCases] = deckValue;
                ++counterCases;
            }
        }
        return this.sim;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

