/*
 * Decompiled with CFR 0.152.
 */
package instructor;

import mindfulness.MindfulnessKnowledge;
import mindfulness.Practice;
import mindfulness.PractitionerAgent;
import simulation.Agent;
import simulation.Simulation;

public abstract class InstructorAgent
implements Agent {
    private MindfulnessKnowledge knowledge;
    private Simulation simulation;

    public InstructorAgent(Simulation simulation) {
        this.simulation = simulation;
        this.knowledge = new MindfulnessKnowledge();
    }

    protected void applyPractice(Practice practice) {
        for (Agent agent : this.simulation.getAgents()) {
            if (!(agent instanceof PractitionerAgent)) continue;
            PractitionerAgent practitioner = (PractitionerAgent)agent;
            this.knowledge.applyPracticeWhenProgress(practitioner, practice, this.simulation.getAgents().size());
        }
    }

    public int getSession() {
        return this.simulation.getIteration() + 1;
    }

    @Override
    public abstract void live();

    public String toString() {
        return this.getClass().getName();
    }
}

