/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package emotions;

import java.text.DecimalFormat;

/**
 * Utils for treating emotions.
 * @author IvanGMG
 */
public class EmotionUtils {
    /** The threshold feeling absolute value below which the ortogonal emotion 
     * is considered neutral.
     */
    public static Double NEUTRAL_THRESHOLD=0.15;
    /** Decimal format of the double values for being printed when 
     representing emotions*/
    public static DecimalFormat EMOTION_FORMAT=new DecimalFormat("#.00000");
    
    /** It returns the opposite emotion of an ortogonal emtion
     * @param ortogonal the ortogonal emotion
     * @return the opposite emotion to the ortogonal one
     */
    public static Emotion oppositeEmotion (OrtogonalEmotion ortogonal){
        Emotion emotion;
        switch(ortogonal){
            case ANGER:
                emotion=Emotion.LOVE;
                break;
            case ANXIETY:
                emotion=Emotion.PRIDE;
                break;
            case DEPRESSION:
                emotion=Emotion.HAPPINESS;
                break;
            default:
                emotion=Emotion.NEUTRAL;
        }
        return emotion;
    }
}
