package mindfulness;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import simulation.*;
import java.util.*;
import javax.swing.*;
import instructor.*;
import emotions.*;
import java.lang.reflect.Constructor;

/**
 * Graphical User Interface (GUI) for performing simulations. It implements
 * ObserverAnimation for being updated each simulation finishes, for starting 
 * with the next one.
 * @author Iván García-Magariño
 */
public class MainGUI extends javax.swing.JFrame  {
    /** The GUI for showing the bodily map **/
    private BodilyMapGUI mapGUI=null;
    /** The last practitioner practitioner created **/
    private PractitionerAgent practitioner;
    
    
    // Previous
    /** Current simulation **/
    private Simulation simulation;
    
    /** Number of Simulations **/
    private int numSimulations;
    /** Counter for the number of simulation that is being run **/
    private int contSim;
    /** Matrix of NxM values where N is the number of practitioners and 
     * M is the number of metrics. Each row has the metrics in the following
     order: (Anger, Anxiety, Depression).
     This matrix is used for calculating the averages and standard deviations*/
    private double [][] results;
    /** This matrix stores the summarizes  of the results for each metric. 
     * It uses the following summarizes in this order in each row:
     * - Avaerages
     * - Standard Deviations
     *  The matrix couldbe represented as summary[summarizeIndex][metricIndex]
     */
    private double [][]summary;
    
   
    /** File Chooser for saving the results */
    private JFileChooser chooser;
    
    
    /** Num of summaries (for now 2, Averages and Standard Deviatons */
    public static int NUM_SUMMARIES=2;
    /** Encoding **/
    public final static Charset ENCODING=StandardCharsets.ISO_8859_1;
    /** Column Length for saving several simulations */
    public final static int COLUMN_LENGTH=15;
    
    /**
     * Creates new form MainGUI
     */
    public MainGUI() {
        initComponents();
        initOtherComponents(); // manually programmed
        // Creates the other GUI for the bodily map
        mapGUI=new BodilyMapGUI();
        mapGUI.setLocation(this.getWidth(), 0);
        mapGUI.setVisible(true);
        // Creates the array for the summaries
        summary= new double[NUM_SUMMARIES][OrtogonalEmotion.values().length];
    }
    
   
    
   /** It performs a mindfulness simulation */
    private void performMindfulnesssSimulation(){
        // Creates the simulation
        simulation = new Simulation();
        // Creates the practitioner practitioner and the instructor practitioner and 
        // register these
        createPractitionerAgents();
        createInstructorAgent();        
        // Run the simulations
        simulation.run(this.readIterations());
        // Show the results
        showResults();
        
        
    }
    
    /** Performs a simulation according to the data **/
    /*@Deprecated
    private void performSimulation(){
        
        // Creates the simulation animation and register as an observer
        simulation = new SimulationAnimation(this);
        simulation.setObserver(this);
        Blackboard.getInstance().setSimulation(simulation);
        try{
            // Creates the agents and register these
            createStudentAgents();
            createInstructorAgent();
            // Set the speed of the simulation
            double speed=readSpeed();
            simulation.setSpeed(speed);
            // Get the number of iterations
            int numIterations=readIterations();
            // Set a measurement evolution objects to record the evolution
            // of sociometrics
            measurement = new MeasurementEvolutionSociogram(numIterations);
            simulation.setMeasurementEvolution(measurement);
            // Run the simulation with the number of iterations
            simulation.run(numIterations);
            // Show the results in graphs
            showResults();
        /* In case some numeric field is empty or without a 
        number, the user is warned *
        }catch(NumberFormatException e){
            JOptionPane.showMessageDialog(this,
                "The inputs of the simulation must contain "
                    + "numeric data. \n "
                    + "Please check that the corresponding "
                    + "fields only contain numbers.");
        }
    }
    */
    
    /** Creates as many practitioner agents as indiciated in the GUI parameter
     **/
    private void createPractitionerAgents(){
        int numPractitioners= readPractitioners();
        for(int i=0; i<numPractitioners; i++){
            createPractitionerAgent();
        }
        
    }
    
    /** Creates the practitioner agent with the values of the UI fields,
 and register this in the simulation
     * */
    private void createPractitionerAgent(){
        practitioner = new PractitionerAgent();
        double value;
        value=Double.parseDouble(this.jTextFieldInitialAnger.getText());
        practitioner.setFeeling(OrtogonalEmotion.ANGER, value);
        value=Double.parseDouble(this.jTextFieldInitialAnxiety.getText());
        practitioner.setFeeling(OrtogonalEmotion.ANXIETY, value);
        value=Double.parseDouble(this.jTextFieldInitialDepression.getText());
        practitioner.setFeeling(OrtogonalEmotion.DEPRESSION, value);
        simulation.register(practitioner);
        
    }
    
    /*
    @Deprecated
    private void createStudentAgents(){
        // Create an empty list of agents
        List<StudentAgent> list=new LinkedList<StudentAgent>();
        StudentAgent practitioner;
        // Creates agents of each type and add these to the sociogram and simulation
        int numAgents;
        numAgents=Integer.parseInt(this.jTextFieldInitialAnger.getText());
        for(int i=0; i<numAgents; i++){
            practitioner=new StudentAgent(AgentType.QUIET);
            simulation.register(practitioner);
            list.add(practitioner);
        }
        numAgents=Integer.parseInt(this.jTextFieldInitialAnxiety.getText());
        for(int i=0; i<numAgents; i++){
            practitioner=new StudentAgent(AgentType.PARTICIPANT);
            simulation.register(practitioner);
            list.add(practitioner);
        }
        numAgents=Integer.parseInt(this.jTextFieldInitialDepression.getText());
        for(int i=0; i<numAgents; i++){
            practitioner=new StudentAgent(AgentType.TANGENT);
            simulation.register(practitioner);
            list.add(practitioner);
        }
        numAgents=Integer.parseInt(this.jTextFieldJoker.getText());
        for(int i=0; i<numAgents; i++){
            practitioner=new StudentAgent(AgentType.JOKER);
            simulation.register(practitioner);
            list.add(practitioner);
        }
        numAgents=Integer.parseInt(this.jTextFieldObstructive.getText());
        for(int i=0; i<numAgents; i++){
            practitioner=new StudentAgent(AgentType.OBSTRUCTIVE);
            simulation.register(practitioner);
            list.add(practitioner);
        }
        numAgents=Integer.parseInt(this.jTextFieldOccasional.getText());
        for(int i=0; i<numAgents; i++){
            practitioner=new StudentAgent(AgentType.OCCASIONAL);
            simulation.register(practitioner);
            list.add(practitioner);
        }
        // Creates a sociogram from the list of agents
        Blackboard.getInstance().createSociogram(list);
    }
    */
    
    /** Creates the instructor practitioner if there is any mindfulness plan, and
 registers this in the simulation. The class are obtained from its name 
     * by reflection.
     */
    public void createInstructorAgent(){
        String strInstructor=""; 
        InstructorAgent instructor=null;
        Class instructorSubclass=null;
        // Select the String of the class depending the JButtorn
        if(this.jRadioButtonDefaultStrategy.getModel().isSelected()){
            strInstructor=(String) this.jComboBoxInstructor.getSelectedItem();
        }else if(this.jRadioButtonNewPlan.getModel().isSelected()){
            strInstructor=this.jTextFieldPlan.getText();
        }
        // Create a instructor practitioner from the name of its class
        try{
            if(!strInstructor.equals("Omitted") && !strInstructor.equals("")){
                instructorSubclass=Class.forName("instructor."+strInstructor);
                Constructor constructor = 
                        instructorSubclass.getConstructor(Simulation.class);
                instructor=(InstructorAgent) constructor.newInstance(simulation);
                //instructor=(InstructorAgent) instructorSubclass.newInstance();
            }
       }catch(Exception e){
           JOptionPane.showMessageDialog(this, 
                   "The instructor plan \""+strInstructor+"\"has not been found, \n"
                   + "so there will not be any instructor agent in the simulation. \n"
                   + "If you are willing to do it so, the next time make sure \n"
                   + "you appropriately compile it in the teacher package and \n"
                   + "introduce its class name (case sensitive) in the field. \n");      
       }
            
        if(instructor!=null){
            simulation.register(instructor);
        }
    }
    
    /** Shows the results of the simulation. In this case, it shows the bodily
 map of the predominantEmotion. **/
    private void showResults(){       
       // Show the predominant feeling of the practitioner 
       Emotion predominantEmotion=practitioner.obtainPredominantEmotion();
       mapGUI.setEmotion(predominantEmotion);
       // Update the size of the table
       this.changeSizeJTableResults(this.readPractitioners());
        // Show the practioners in the GUI table of results, and include the 
        // these in the array for calculating the summary later
       results=new double[readPractitioners()][OrtogonalEmotion.values().length];
       int row=0;
       for(Agent agent:simulation.getAgents()){
           if(agent instanceof PractitionerAgent){
               practitioner=(PractitionerAgent) agent;
               for(OrtogonalEmotion emotion: OrtogonalEmotion.values()){
                    results[row][emotion.ordinal()]=practitioner.getFeeling(emotion);
               }
               printEmotionResults(practitioner, row);
               row++;
           }
       }
       // Calculate the summary and shows it
       calculateSummary();
       showSummary();
       // Test: show all the agents of the simulation
        System.out.println(simulation);
       
    }
    /** Prints the predominantEmotions of a practitioner in a row of the table
 with the results.
     * @param practitioner the practitioner
     * @param row the row in which the paractitioner emotions will be printed
     */ 
    public void printEmotionResults(PractitionerAgent practitioner, int row){
        for(OrtogonalEmotion emotion: OrtogonalEmotion.values()){
                // Print id. of the practitioner
                jTableResults.getModel().setValueAt(""+(row+1), row, 0);
                // Print emotions
                jTableResults.getModel().setValueAt(
                        EmotionUtils.EMOTION_FORMAT.format(
                        practitioner.getFeeling(emotion)),
                        row, emotion.ordinal()+1);
        }
    }
    
    /** Returns the number of minfulness sessions (i.e. iterations) 
     * indicated by the user **/
    private int readIterations(){
        return Integer.parseInt(this.jTextFieldIterations.getText());
    }
    /** Returns the number of practitioners indicated by the user **/
    private int readPractitioners(){
        return Integer.parseInt(this.jTextFieldNumPractitioners.getText());
    }
    
    /* Returns the number of simulations indicated by the user **/
    /*
    private int readSimulations(){
        return Integer.parseInt(this.jTextFieldNumSimulations.getText());
    }
    */
    
    /* Returns the speed (iterations/second) of the simulation indicated 
     * by the user **/
    /*
    private double readSpeed(){
        String str=(String) this.jComboBoxSpeed.getSelectedItem();
        double speed=Double.parseDouble(str);
        return speed;     
    }
    */
 
    /** Init other components manually indtroduced by the programmer */
    public void initOtherComponents(){
        chooser= new JFileChooser();
        // Add ratio buttons to a group
        this.buttonGroupStrategy.add(this.jRadioButtonDefaultStrategy);
        this.buttonGroupStrategy.add(this.jRadioButtonNewPlan);
        this.buttonGroupStrategy.setSelected(jRadioButtonDefaultStrategy.getModel(), true);
        
    }
    
    
    
    /** Starts the running of several simulations, and the end of each
     * simulation is notified through the undateFinishedSimulation method."
     */
    /*
    @Deprecated
    public void performSeveralSimulations(){
        // Obtain the number of metrics and init the arrays
        int numMetrics=MeasurementEvolutionSociogram.NUM_METRICS;
        numSimulations=readSimulations();
        sociograms=new Sociogram[numSimulations];
        measurements=new MeasurementEvolutionSociogram[numSimulations];
        results= new double[numSimulations][numMetrics];
        summary= new double[NUM_SUMMARIES][numMetrics];
        // Creates the GUI of the Sociogram
        mapGUI=new BodilyMapGUI();
        mapGUI.setVisible(true);
        //sociogramGUI= new SociogramGUI();
        //sociogramGUI.setVisible(true);
        //Blackboard.getInstance().setSociogramGUI(sociogramGUI);
        // Sets the size of the Table of Results in GUI and clear the table of
        // the summary
        changeSizeJTableResults(numSimulations);
        clearJTableSummary();
        // Perform the first simulation.
        contSim=0;   
        performSimulation();
        
    }
    */
    
    
    /** When a simulation is finished (notified as an observer), it records
     * the state of the finished simulation, and starts the next simulation
     * if necessary.
     */
    /*
    public void updateFinishedSimulation() {
        // Record the state
        Sociogram sociogram = Blackboard.getInstance().getSociogram();
        sociograms[contSim]=sociogram;
        measurements[contSim]=measurement; 
        // Store and print the measurement values in the table of the results
        double iag, icg, idg, iig;
        iag=sociogram.measureIAg();
        icg=sociogram.measureICg();
        idg=sociogram.measureIDg();
        iig=sociogram.measureIIg();
        results[contSim][0]=iag;
        results[contSim][1]=icg;
        results[contSim][2]=idg;
        results[contSim][3]=iig;        
        jTableResults.getModel().setValueAt(""+(contSim+1), contSim, 0);
        jTableResults.getModel().setValueAt(Sociogram.METRIC_FORMAT.format(iag), contSim, 1);
        jTableResults.getModel().setValueAt(Sociogram.METRIC_FORMAT.format(icg), contSim, 2);
        jTableResults.getModel().setValueAt(Sociogram.METRIC_FORMAT.format(idg), contSim, 3);
        jTableResults.getModel().setValueAt(Sociogram.METRIC_FORMAT.format(iig), contSim, 4);
        // Increments the counter of simulations
        contSim++;
        // If below the limit, it starts a new simulation
        if(contSim<numSimulations){
            performSimulation();
        }
        // If all the simulations are performed, it calcculates the summary
        // and shows it
        else{
            calculateSummary();
            showSummary();
        }
    }
    */
    
    /** Calculates the summary of the results (averages and standard 
     * deviations **/
    public void calculateSummary(){
        //int numMetrics=MeasurementEvolutionSociogram.NUM_METRICS;
        int numMetrics=OrtogonalEmotion.values().length;
        ///// Calculates the average of all metrics (all in row zero of matrix)
        int indexAvrg=0;
        // Starts with zero
        for(int i=0; i<numMetrics;i++){
            summary[indexAvrg][i]=0;
        }
        // Gets the sum of results
        int numPractitioners=readPractitioners();
        for (int i=0;i<numPractitioners;i++){
            for(int j=0;j<numMetrics;j++){
                summary[indexAvrg][j]= summary[indexAvrg][j]+results[i][j];
            }
        }
        // Divides the summary by the number os simulations
        for(int j=0;j<numMetrics;j++){
                summary[indexAvrg][j]= summary[indexAvrg][j]/numPractitioners;
        }
        
        ///// Calculates the Standar Deviations of all metrics 
        //(all in row one of matrix)
        int indexSD=1;
        // Starts with zero
        for(int i=0; i<numMetrics;i++){
            summary[indexSD][i]=0;
        }
        // Gets the sum of the squares of the differences
        for (int i=0;i<numPractitioners;i++){
            for(int j=0;j<numMetrics;j++){
                // Difference to the average
                double diff= results[i][j]-summary[indexAvrg][j];
                // Square of the difference
                double square = Math.pow(diff, 2);
                // Sum the square
                summary[indexSD][j]=summary[indexSD][j]+square; 
            }
        }
        // Gets the averages of squares, and then calculate the square root
        for(int j=0;j<numMetrics;j++){
                // Average of squares
                summary[indexSD][j]= summary[indexSD][j]/numPractitioners;
                // Calculate the square root
                summary[indexSD][j]= Math.sqrt(summary[indexSD][j]);
        }
        
    }
    /** It shows the summary in the GUI **/
    public void showSummary(){
        // Prints the row headers
        jTableSummary.setValueAt("Average", 0, 0);
        jTableSummary.setValueAt("SD", 1, 0);
        // Copy the summary values
        for (int i=0;i<NUM_SUMMARIES;i++){
            for(int j=0;j<OrtogonalEmotion.values().length;j++){
                // Copy values but but summing one to the column to consider row headers
                jTableSummary.setValueAt(EmotionUtils.EMOTION_FORMAT.format(summary[i][j]), i, j+1);
            }
        }
    }
    
    /* It saves several simulations */
    /*
    public void saveSeveralSimulations(PrintStream out){
        out.println("-- Results provided by the ABS-SOCI simulator --");
        // Save the input parameters
        saveInputParameters(out);
        // Save the Results
        out.println();
        out.println("---------- SOCIOMETRICS OF ALL SIMULATIONS ----------");
        saveJTable(jTableResults, out, numSimulations);
        // Save the Summary of the Results
        out.println();
        out.println("---------- SUMMARY OF THE RESULTS ------------");
        saveJTable(jTableSummary, out, NUM_SUMMARIES);
        // Save each simulation (final sociogram and measurement evolution
        for(int i=0;i<numSimulations;i++){
            out.println();
            out.println("----------- SIMULATION "+(i+1)+" ------------");        
             // Save the sociogram
             sociograms[i].save(out);
            // Save the evolution
            measurements[i].saveValues(out);
        }
        
    }
    */
    /** It saves the contents of the JTable. It is used for saving several 
     tables.
     @param jtable The JTable of the GUI that will be saved
     @param out The PrintStream in which the content of the table will be printed.
     @param numRows The number of rows that will be printed**/
    public void saveJTable(JTable jtable, PrintStream out, int numRows){
        String str;
        // Prints the headers
        for(int i=0;i<jtable.getModel().getColumnCount();i++){
            str=jtable.getModel().getColumnName(i);
            str=String.format("%1$"+COLUMN_LENGTH+"s", str);
            out.print(str+"\t");
        }    
        // Print the values
        out.println();
        for (int i=0;i<numRows;i++){
            for(int j=0;j<jtable.getModel().getColumnCount();j++){
                str=(String) jtable.getValueAt(i, j);
                str=String.format("%1$"+COLUMN_LENGTH+"s", str);
                out.print(str+"\t");
            }
            out.println();
        }
    }
    
    /* Save the input parameters from the GUI into the print 
    stream of the parameter 
    public void saveInputParameters(PrintStream out){
        out.println();
        out.println("INPUT PARAMETERS");
        out.println("Quite Students = "+this.jTextFieldInitialAnger.getText());
        out.println("Participant Students = "+this.jTextFieldInitialAnxiety.getText());
        out.println("Tangent Students = "+this.jTextFieldInitialDepression.getText());
        out.println("Joker Students = "+this.jTextFieldJoker.getText());
        out.println("Obstructive Students = "+this.jTextFieldObstructive.getText());
        out.println("Occasional Students = "+this.jTextFieldNumPractitioners.getText());
        out.println("Number of Iterations = "+this.jTextFieldIterations.getText());
        out.println("Number of Simulations = "+this.jTextFieldNumSimulations.getText());        
    }
    */
    
    /** It changes the number of rows of jTableResults, so users can define
     * an unlimited number of simulations.
     * @param numRows Number of Rows
     */
    public void changeSizeJTableResults(int numRows){
        String[] titles = new String [] {
                "Id. Practitioner", "Anger", "Anxiety", "Depression", 
            };
        Object[][] objects=new Object[numRows][titles.length];
        for (int i=0;i<numRows;i++){
            for(int j=0;j<titles.length;j++){
                objects[i][j]=null;
            }
        }
        jTableResults.setModel(new javax.swing.table.DefaultTableModel(
            objects, titles
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(jTableResults);
    }
    /** It clears the table with the summaries **/
    public void clearJTableSummary(){
        // Read the number of metrics
        int numMetrics = OrtogonalEmotion.values().length;
        // The number of colums is the the number of metrics plus one
        for (int i=0;i<NUM_SUMMARIES;i++){
            for(int j=0; j<numMetrics+1; j++){
                jTableSummary.setValueAt("", i, j);
            }
        }
    }
    
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        buttonGroupStrategy = new javax.swing.ButtonGroup();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldInitialAnger = new javax.swing.JTextField();
        jLabelCouple = new javax.swing.JLabel();
        jTextFieldInitialAnxiety = new javax.swing.JTextField();
        jLabelFamilyBabies = new javax.swing.JLabel();
        jTextFieldInitialDepression = new javax.swing.JTextField();
        jLabelTrips = new javax.swing.JLabel();
        jTextFieldIterations = new javax.swing.JTextField();
        jLabelInput1 = new javax.swing.JLabel();
        jButtonRunSimulation = new javax.swing.JButton();
        jTextFieldNumPractitioners = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableResults = new javax.swing.JTable();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTableSummary = new javax.swing.JTable();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jComboBoxInstructor = new javax.swing.JComboBox();
        jRadioButtonDefaultStrategy = new javax.swing.JRadioButton();
        jRadioButtonNewPlan = new javax.swing.JRadioButton();
        jTextFieldPlan = new javax.swing.JTextField();

        jLabel1.setText("jLabel1");

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane2.setViewportView(jTable1);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("ABSEM (an ABS of Emotions in Mindfulness programs)");

        jLabel2.setText("Initial Anger:");

        jTextFieldInitialAnger.setText("0.12000");
        jTextFieldInitialAnger.setToolTipText("");
        jTextFieldInitialAnger.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldInitialAngerActionPerformed(evt);
            }
        });

        jLabelCouple.setText("Initial Anxiety:");

        jTextFieldInitialAnxiety.setText("0.15952");
        jTextFieldInitialAnxiety.setToolTipText("");
        jTextFieldInitialAnxiety.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldInitialAnxietyActionPerformed(evt);
            }
        });

        jLabelFamilyBabies.setText("Initial Depression:");

        jTextFieldInitialDepression.setText("0.19762");
        jTextFieldInitialDepression.setToolTipText("");
        jTextFieldInitialDepression.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldInitialDepressionActionPerformed(evt);
            }
        });

        jLabelTrips.setText("Number of Sessions:");

        jTextFieldIterations.setText("8");
        jTextFieldIterations.setToolTipText("");
        jTextFieldIterations.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldIterationsActionPerformed(evt);
            }
        });

        jLabelInput1.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        jLabelInput1.setText("Parameters of the Simulation");
        jLabelInput1.setToolTipText("");

        jButtonRunSimulation.setText("Run Simulation");
        jButtonRunSimulation.setToolTipText("");
        jButtonRunSimulation.setActionCommand("RunSimulation");
        jButtonRunSimulation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                runSimulationActionPerformed(evt);
            }
        });

        jTextFieldNumPractitioners.setText("21");
        jTextFieldNumPractitioners.setToolTipText("");
        jTextFieldNumPractitioners.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldNumPractitionersActionPerformed(evt);
            }
        });

        jLabel3.setText("Number of Practitioners:");

        jLabel6.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        jLabel6.setText("Results");

        jTableResults.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null},
                {null, null, null, null, null}
            },
            new String [] {
                "Id. Simulation", "Anger", "Anxiety", "Depression", ""
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(jTableResults);

        jTableSummary.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null, null},
                {null, null, null, null, null}
            },
            new String [] {
                "", "Anger", "Anxiety", "Depression", ""
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false, true
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane3.setViewportView(jTableSummary);

        jLabel7.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        jLabel7.setText("Summary of the Results");

        jLabel8.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        jLabel8.setText("Mindfulness Program:");
        jLabel8.setToolTipText("");

        jComboBoxInstructor.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Omitted", "Wongtongkam", "Song" }));
        jComboBoxInstructor.setSelectedIndex(2);
        jComboBoxInstructor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxInstructorActionPerformed(evt);
            }
        });

        jRadioButtonDefaultStrategy.setSelected(true);
        jRadioButtonDefaultStrategy.setText("Default Program");
        jRadioButtonDefaultStrategy.setToolTipText("");
        jRadioButtonDefaultStrategy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonDefaultStrategyActionPerformed(evt);
            }
        });

        jRadioButtonNewPlan.setText("User Program");
        jRadioButtonNewPlan.setToolTipText("");
        jRadioButtonNewPlan.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNewPlanActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jLabel2)
                            .addComponent(jLabelCouple, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jLabelFamilyBabies)
                            .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jLabelTrips))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTextFieldInitialAnxiety)
                            .addComponent(jTextFieldInitialAnger)
                            .addComponent(jTextFieldInitialDepression)
                            .addComponent(jTextFieldNumPractitioners)
                            .addComponent(jTextFieldIterations)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jButtonRunSimulation)
                            .addComponent(jRadioButtonNewPlan)
                            .addComponent(jRadioButtonDefaultStrategy))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jComboBoxInstructor, 0, 123, Short.MAX_VALUE)
                            .addComponent(jTextFieldPlan)))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel8)
                            .addComponent(jLabelInput1))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel7)
                    .addComponent(jLabel6)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 452, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(25, 25, 25))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(21, 21, 21)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelInput1)
                    .addComponent(jLabel6))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel2)
                            .addComponent(jTextFieldInitialAnger, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabelCouple)
                            .addComponent(jTextFieldInitialAnxiety))
                        .addGap(4, 4, 4)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabelFamilyBabies)
                            .addComponent(jTextFieldInitialDepression))
                        .addGap(49, 49, 49)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jTextFieldNumPractitioners, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelTrips)
                            .addComponent(jTextFieldIterations, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 224, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, Short.MAX_VALUE)))
                .addComponent(jLabel7)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(18, 18, 18)
                        .addComponent(jLabel8)
                        .addGap(9, 9, 9)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jComboBoxInstructor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jRadioButtonDefaultStrategy))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jRadioButtonNewPlan)
                            .addComponent(jTextFieldPlan, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(11, 11, 11)
                        .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(1, 1, 1)
                .addComponent(jButtonRunSimulation)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jTextFieldInitialAngerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldInitialAngerActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldInitialAngerActionPerformed

    private void jTextFieldInitialAnxietyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldInitialAnxietyActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldInitialAnxietyActionPerformed

    private void jTextFieldInitialDepressionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldInitialDepressionActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldInitialDepressionActionPerformed

    private void jTextFieldIterationsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldIterationsActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldIterationsActionPerformed
    
    private void jTextFieldNumPractitionersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldNumPractitionersActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldNumPractitionersActionPerformed
    
    
    private void jComboBoxInstructorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxInstructorActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jComboBoxInstructorActionPerformed

    private void jRadioButtonDefaultStrategyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonDefaultStrategyActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButtonDefaultStrategyActionPerformed

    private void jRadioButtonNewPlanActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonNewPlanActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButtonNewPlanActionPerformed

    /** Method for running the simulations, executed when pressing the "Run 
     * Simulation" button.
     * @param evt 
     */
    private void runSimulationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_runSimulationActionPerformed
        this.performMindfulnesssSimulation();
    }//GEN-LAST:event_runSimulationActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /*
         * Set the Nimbus look and feel
         */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /*
         * If Nimbus (introduced in Java SE 6) is not available, stay with the
         * default look and feel. For details see
         * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(MainGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(MainGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(MainGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(MainGUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /*
         * Create and display the form
         */
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new MainGUI().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupStrategy;
    private javax.swing.JButton jButtonRunSimulation;
    private javax.swing.JComboBox jComboBoxInstructor;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabelCouple;
    private javax.swing.JLabel jLabelFamilyBabies;
    private javax.swing.JLabel jLabelInput1;
    private javax.swing.JLabel jLabelTrips;
    private javax.swing.JRadioButton jRadioButtonDefaultStrategy;
    private javax.swing.JRadioButton jRadioButtonNewPlan;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTableResults;
    private javax.swing.JTable jTableSummary;
    private javax.swing.JTextField jTextFieldInitialAnger;
    private javax.swing.JTextField jTextFieldInitialAnxiety;
    private javax.swing.JTextField jTextFieldInitialDepression;
    private javax.swing.JTextField jTextFieldIterations;
    private javax.swing.JTextField jTextFieldNumPractitioners;
    private javax.swing.JTextField jTextFieldPlan;
    // End of variables declaration//GEN-END:variables

   
}
