/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package emotions;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

/**
 * This panel shows the emotion of a practitioner.
 * @author IvanGMG
 */
public class BodilyMapPanel extends JPanel{
    /** Images of the bodily maps. It contains a different image for each
     * emotion. */
    private BufferedImage[] images;
    /** It contains the emotion of the practitioner **/
    private Emotion emotion;
    
    /** Width of each image in pixels*/
    public static int WIDTH_IMG=80;
    /** Height of each image in pixels*/
    public static int HEIGHT_IMG=240;
    /** Folder of the images **/
    public static String FOLDER_IMG="img/";
    /** Folder of the images **/
    public static String EXTENSION_IMG=".jpg";
    

    /** Default constructor of the class. It loads the images of the emotions.
     **/
    public BodilyMapPanel(){
       loadImages();
       this.setEmotion(Emotion.NEUTRAL);
    }
    /** It loads the images of all emotions. It uses the length and names
     of the Emotion enumeration*/
    public void loadImages(){
       // Creates the array of emotions 
       int numEmotions= Emotion.values().length;
       images = new BufferedImage[numEmotions];
       // Load Each emotion
       int count=0; 
       for(Emotion emotion : Emotion.values()){
           System.out.println(emotion);
           try {   
                String path =FOLDER_IMG + emotion.name()+EXTENSION_IMG;
                images[count] = ImageIO.read(new File(path));           
                System.out.println("Img loaded properly");
            } catch (IOException e) {
                System.out.println("Error loading file:" +e.getMessage());
            } 
           count++;
       }
    }
    
    /** It sets an emotion and graphically shows its bodily map
     * @param emotion The established emotion
     */
    public void setEmotion(Emotion emotion){
        this.emotion=emotion;
        this.repaint();
    }

    /** It paints the bodily map image of the current emotion**/
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(images[emotion.ordinal()], 0, 0, null); // see javadoc for more info on the parameters            
    }
    
}
