/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package instructor;
import simulation.*;
import emotions.*;
import mindfulness.*;
     

/**
 * This class represents the instructor. It needs to be extended with
 * the instructor with the specific mindfulness plans
 * @author IvanGMG
 */
public abstract class InstructorAgent implements Agent{
    /** It contains the knowledge necessary for updating the emotions of 
    * of practitioners according to different mindfulness practices.
    */
    private MindfulnessKnowledge knowledge;
    /** A reference to the simulation for accessing all the practitioner
     * agents when necessary.
     */
    private Simulation simulation;
    
    /** It creates instructor agent with the necessary mindfulness knowledge.
     It also sets a referenet to the simulation*/
    public InstructorAgent(Simulation simulation){
        this.simulation=simulation;
        knowledge=new MindfulnessKnowledge();
    }
    
    /** This method applies a mindfulness practice in all the practitioner 
     * agents of the simulation.
     */
    protected void applyPractice(Practice practice){
        for (Agent agent: simulation.getAgents()){
            if(agent instanceof PractitionerAgent){
                PractitionerAgent practitioner=(PractitionerAgent)agent;
                knowledge.applyPracticeWhenProgress(practitioner, practice,
                        simulation.getAgents().size());
            }
        }
    }
    /** It returns the session of the practice. The session number is the
     * number of the simulation iteration plus one.
     * @return the position of current session starting in one.
     */
    public int getSession(){
        return simulation.getIteration()+1;
    }
    
    
    /** This method is periodically called within the agent-based simulator, and 
     * is used for defining mindfulness instructor plangs. It must be
     * implemented in the subclasses of this class. **/
    public abstract void live();
    
    /** It returns the name of the class that represents the mame of 
    * the instructor mindfulness plan.
    * @return representative string
    */
    public String toString(){
        return this.getClass().getName();
    }
}
