/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package instructor;
import mindfulness.Practice;
import simulation.*;

/** It represents the program for instructing mindfulness proposed by 
 * Song et al. (2015). 
 * @author Iván García-Magariño */
public class Song extends InstructorAgent{
    /** Constructor that sets the simulation with the super constructor. */
    public Song(Simulation simulation){
        super(simulation);
    }  
    /** It determines the mindfulness program of an instructor 
     according to the work of Song et al.(2015). **/
    @Override
    public void live() {
        // Practices for each session
        switch(getSession()){
            case 1: // First Session
                applyPractice(Practice.BODY_SCAN);
                break;
            case 2: // Second Session
                applyPractice(Practice.MINDFUL_EATING);
                break;
            case 3: // Third Session
                applyPractice(Practice.MINDFUL_BREATHING);
                break;
            case 4: // Fourth Session
                applyPractice(Practice.SITTING_MEDITATION);
                break;
            case 5: // Fifth Session
                applyPractice(Practice.WALKING_MEDITATION);
                break;
            case 6: // Sixth Session
                applyPractice(Practice.MINDFUL_MOVEMENT);
                break;
            case 7: // Seventh Session
                applyPractice(Practice.MINDFUL_EATING);
                applyPractice(Practice.MINDFUL_BREATHING);
                break;
            case 8: // Eighth Session
                applyPractice(Practice.WALKING_MEDITATION);
                applyPractice(Practice.MINDFUL_MOVEMENT);             
        }             
    }    
}