/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package instructor;
import mindfulness.Practice;
import simulation.*;

/** It represents an instructor with the mindfulness program 
 * proposed by Wongtongkam et al. (2015). 
 * @author Iván García-Magariño */
public class Wongtongkam extends InstructorAgent{
    /** Constructor that stores a reference to the simulation. */
    public Wongtongkam(Simulation simulation){
        super(simulation);
    }  
    /** It determines the mindfulness program of an instructor 
     according to the work of Wongtongkam et al.(2015). **/
    @Override
    public void live() {
        // All the sessions have the following practices:
        applyPractice(Practice.MINDUFL_MANTRAS);
        applyPractice(Practice.MINDFUL_BREATHING);
        applyPractice(Practice.CONSCIOUS_OBSERVATION);
        applyPractice(Practice.WALKING_MEDITATION);
        applyPractice(Practice.LECTURE_BEHAVIOR_TOWARDS_OTHERS);
        applyPractice(Practice.SITTING_MEDITATION);
    }    
}
