/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package mindfulness;
import emotions.*;
import deck.DeckRandom; // From "atabs.jar"

/**
 * This class contains the knowledge about mindfulness practices. In particular,
 * it determines the influence of each practice in the emotions.
 * @author IvanGMG
 */
public class MindfulnessKnowledge {
    /** This matrix contains the proportional influence on each emotion from
     * each mindfulness practice. The order is (emotion, practice). */
    private double proportionalInfluence[][];
    /** This matrix contains the incremental influence on each emotion from
     * each mindfulness practice. The order is (emotion, practice) */
    private double incrementalInfluence[][];
    /** Deck random generator that determines when each practitioner progresses
     * with each practice.
     */
    private DeckRandom progressDeck;
    /** It determines the value positive choices of the progress Deck generator **/
    private int progressValue=90; // e.g. 9  or 90    
    /** It contains the size of the progress Deck generator */
    private int progressSize=100; // e.g. 10 or 100
    /** The maximum number of agents for omitting the progress 
     * conditioning. The minimum number for this limit is one practitioner
     * and one instructor (i.e. two).*/
    private int limitAgentsProgress = 2;
    
    /** Default values for the matrix about proportional influence **/
    private final static double DEFAULT_PROPORTION=-0.2;
    /** Default values for the matrix about proportional influence **/
    private final static double DEFAULT_INCREMENT=0.0;
    
    /** It creates the knowledge about mindfulness influences with
     * the default values, and then establishes the known influences **/
     public MindfulnessKnowledge(){
         // Create the influence matrices with size of 
         // (OrtogonalEmotion x Practice)
         int sizeEmotions = OrtogonalEmotion.values().length;
         int sizePractice = Practice.values().length;
         proportionalInfluence=new double[sizeEmotions][sizePractice];
         incrementalInfluence=new double[sizeEmotions][sizePractice];
         for(int i=0; i<sizeEmotions; i++){
             for(int j=0; j<sizePractice; j++ ){
                 proportionalInfluence[i][j]=DEFAULT_PROPORTION;
                 incrementalInfluence[i][j]=DEFAULT_INCREMENT;
             }
         }
         // Creates the known influences
         createKnownInfluences();
         // Creates the progress Deck random generator
         progressDeck =new DeckRandom(progressValue, progressSize);
     }
     /** It creates the known influences of some mindfulness practices. **/
     public void createKnownInfluences(){
         // Learned from Wongtongkom
         incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()]
                 [Practice.MINDUFL_MANTRAS.ordinal()]=-0.0000056;
         incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()]
                 [Practice.MINDFUL_BREATHING.ordinal()]=-0.0002686;
         incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()]
                 [Practice.CONSCIOUS_OBSERVATION.ordinal()]=-0.0011372;
         incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()]
                 [Practice.WALKING_MEDITATION.ordinal()]=-0.0004404;
         incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()]
                 [Practice.LECTURE_BEHAVIOR_TOWARDS_OTHERS.ordinal()]=-0.0009054;
         incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()]
                 [Practice.SITTING_MEDITATION.ordinal()]=-0.0006819;
         incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()]
                 [Practice.MINDUFL_MANTRAS.ordinal()]=-0.0000060;   
         
         // Learned from Song
         incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()]
                 [Practice.BODY_SCAN.ordinal()]=-0.0371257; 
         incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()]
                 [Practice.BODY_SCAN.ordinal()]=-0.0265972; 
         incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()]
                 [Practice.MINDFUL_EATING.ordinal()]=-0.0285857; 
         incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()]
                 [Practice.MINDFUL_EATING.ordinal()]=-0.0214170; 
         incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()]
                 [Practice.MINDFUL_BREATHING.ordinal()]=-0.0001603; 
         incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()]
                 [Practice.MINDFUL_BREATHING.ordinal()]=-0.0013937; 
         incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()]
                 [Practice.SITTING_MEDITATION.ordinal()]=-0.0001603; 
         incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()]
                 [Practice.SITTING_MEDITATION.ordinal()]=-0.0013937; 
         incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()]
                 [Practice.WALKING_MEDITATION.ordinal()]=-0.0003683; 
         incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()]
                 [Practice.WALKING_MEDITATION.ordinal()]=-0.0027248; 
         incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()]
                 [Practice.MINDFUL_MOVEMENT.ordinal()]=-0.0038289; 
         incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()]
                 [Practice.MINDFUL_MOVEMENT.ordinal()]=-0.0157860; 
         
         // Learned for the obsolete alternative of Wongtongkom
         incrementalInfluence[OrtogonalEmotion.ANGER.ordinal()]
                 [Practice.MINDFULNESS_MEDITATION.ordinal()]=-0.0024908;
         incrementalInfluence[OrtogonalEmotion.ANXIETY.ordinal()]
                 [Practice.MINDFULNESS_MEDITATION.ordinal()]=-0.0029012;
         incrementalInfluence[OrtogonalEmotion.DEPRESSION.ordinal()]
                 [Practice.MINDFULNESS_MEDITATION.ordinal()]=-0.0021431;
     }
     /** It applies a mindfulness practice on a practitioner considering
      * they can progress or not with the corresponding Deck random generator. 
      * It simulating its influence in the emotions of the practitioner with 
      * a conditional invokation of the "applyPractice" method. The progress
      * conditioning is only applied when the number of agents surpasses 
      * the corresponding limit.
      * @param practitioner the practitioner
      * @param practice the mindfulness practice
      * @param numAgents the number of agents of the simulation
      */
     public void applyPracticeWhenProgress(PractitionerAgent practitioner, 
             Practice practice, int numAgents){
         // If the number of agent surpasses the limit, omit the conditioning.
         if(numAgents<=this.limitAgentsProgress){
             applyPractice(practitioner, practice);
         // Otherwise, simulates the progress conditioning for whether 
         // influencing or not
         } else if(progressDeck.nextInt()==DeckRandom.YES){
             applyPractice(practitioner, practice);
         }
     }
     
     /** It applies a mindfulness practice on a practitioner simulating its 
      * influence in the emotions of the practitioner. It applies the 
      * the proportional influence or incremental influence, considering the
      * one with the lowest absolute value. 
      * @param practitioner the practitioner
      * @param practice the mindfulness practice
      */
     public void applyPractice(PractitionerAgent practitioner, Practice practice){
        // Variables with the meaning of article
        // Fi: feeling of emotion i; 
        // Dij: proportional unfluence;
        // Aij: Increment according to the proportional influence;
        // Sij: Increment accroding to the incremental influence;
        double Fi, Dij, Aij, Sij; 
        // For each emotion, it calculates the new feeling
         for (OrtogonalEmotion emotion:OrtogonalEmotion.values()){
             // Obtains the values of variables
             Fi = practitioner.getFeeling(emotion);
             Dij = proportionalInfluence[emotion.ordinal()][practice.ordinal()];
             Sij = incrementalInfluence[emotion.ordinal()][practice.ordinal()];
             // Calculates the proportional increment
             Aij=Dij * (1-Math.abs(Fi));
             // Calculates the new feeling considering the increment with
             // the minimum absolute value
             if(Math.abs(Aij)<Math.abs(Sij)){
                 Fi=Fi+Aij;
             }else{
                 Fi=Fi+Sij;
             }
             // Sets the new feeling in the practitiner
             practitioner.setFeeling(emotion, Fi);
         }
     }
}
