/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package mindfulness;
import emotions.*;
import simulation.*;

/**
 * This class simulates a practitioner agent. This agent contains
 * the feelings of the ortogonal emotions.
 * @author IvanGMG
 */
public class PractitionerAgent implements Agent{
    /** It contains the feelings of the practitioner about all
     * the emotions. All values are in the range [0, 1].
     */
    private double feelings[];
    /** It creates  a practitioner with all the feelings with the 
     * zero value, for the ortogonal emotions.
     */
    public PractitionerAgent(){
        feelings=new double[OrtogonalEmotion.values().length];
        for(int i=0;i<feelings.length;i++){
            feelings[i]=0.0;
        }
    }
    /** It sets the initial feeling about an emotion
     * @param emotion The emotion that is established.
     * @param feelingValue Value of the initial feeling.
     */
    public void setFeeling(OrtogonalEmotion emotion, double feelingValue){
        feelings[emotion.ordinal()]=feelingValue;
    }
    /** It gets the current feeling about an emotion.
     * @param emotion the emotion
     * @return the feeling value of the corresponding emotion
     */
    public double getFeeling(OrtogonalEmotion emotion){
        return feelings[emotion.ordinal()];
    }
    
    /** It returns the predominan emotion considering all the emotions not
     * only the ortogonal emotions.
     */
    public Emotion obtainPredominantEmotion(){
        // Gets the ortognal emotion with the highest absolute value
        OrtogonalEmotion maxEmotion=OrtogonalEmotion.values()[0];
        double maxValue=Double.MIN_VALUE;
        double valueAbs;
        for (OrtogonalEmotion emotion:OrtogonalEmotion.values()){
           valueAbs=Math.abs(feelings[emotion.ordinal()]);
           if(valueAbs>maxValue){
               maxValue=valueAbs;
               maxEmotion=emotion;
           }
        }
        // The maximum emotion is considered to be predominant if surpasses
        // the neutral threshold.
        Emotion predominant=Emotion.NEUTRAL;
        if(maxValue>EmotionUtils.NEUTRAL_THRESHOLD){
            // If positive feeling value
            if(feelings[maxEmotion.ordinal()]>0){
                predominant=Emotion.valueOf(maxEmotion.toString());
            // If negative feeling value
            }else{
               predominant=EmotionUtils.oppositeEmotion(maxEmotion);
            }
        }
        return predominant;            
    }
    
    /** Provides a string that represents the practitioner agent 
     @return the representative string**/
    public String toString(){
        String str= "PractitionerAgent(";
        for(int i=0;i<feelings.length;i++){
            str+=OrtogonalEmotion.values()[i];
            str+=":"+feelings[i]+"; ";
        }
        str+=")";
        return str;
    }

    /** Method that performs in each simulation iteration **/
    @Override
    public void live() {
        
    }
}
