/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package simulation;

import java.io.PrintStream;
import java.text.DecimalFormat;

/**
 * This class records the evolution of several metrics for each iteration.
 * Then, the recorded values can be printed in a PrintStream. This class is
 * abstract and needs that the method recordValues is implemented in the 
 * subclasses. This method must record the values that are specific of a 
 * particular simulator. The subclases also must set the names of the metrics
 * in the metrics attribute
 * @author IvanGMG
 */
public abstract class MeasurementEvolution {
    /** Names of the metrics. The subclasses must set thes value **/
    protected String [] metrics;
    /** Number of iterations **/
    private int numIterations;
    /** Measurement values of the metrics for each iteration, in which 
     * values[iteration][metric] represents for a particular iteration the 
     * measurement value of the corresponding metric number.
     */
    protected double[][] values;
    /** Format of the double values printed in the text file for representing
     * the sociogrametric values.*/
    private static DecimalFormat METRIC_FORMAT=new DecimalFormat("#.00000");
    /** Number of characters that is used for representing each column**/
    public static int COLUMN_LENGTH=8;
    /** Constructor of the class. It also needs the number of iterations.
    @param numIterations Number of iterations and the number of metrics.
    */
    public MeasurementEvolution(int numIterations, int numMetrics){
        this.numIterations=numIterations;
        values = new double[numIterations][numMetrics];
    }
    /** The implementation must record the measurment values specific of 
     * each simulator. For this reason, this method is abstract and must be
     * implemented in the subclasses. It can call the other method 
     * recordValues(iteration, valuesIter).
     */
    public abstract void recordValues();
    
    /** Records the measurement values of a particular iteration 
     * @param iteration The number of the iteration in which the measurement
     * values are recorded.
     * @param valuesIter The measurement values of a particular iteration 
     following the same order of metrics as the given in the constructor. 
     **/
    public void recordValues(int iteration, double[] valuesIter){
        // Check for errors
        if(valuesIter.length>values.length){
            System.out.println("Error in MeasurementEvolution:recordValues");
            return;
        }
        // Copy the measurement values in this class 
        for(int metric=0;metric<valuesIter.length;metric++){
            values[iteration][metric]=valuesIter[metric];
        }
    }
    /** Save the all the recorded measurement values by printing these in an 
     * open PrintStream 
     @param out The stream where the measurement values are printed. 
     **/
    public void saveValues(PrintStream out){
        String str;
        out.println();
        out.println("EVOLUTION OF THE SOCIOMETRICS THROUGH THE ITERATIONS");
        // Print the header of columns 
        str= "Iteration";
        str=String.format("%1$"+COLUMN_LENGTH+"s", str);
        out.print(str+"\t");
        for(int i =0; i<metrics.length; i++){
            str=metrics[i];
            str=String.format("%1$"+COLUMN_LENGTH+"s", str);
            out.print(str+"\t");
        }
        out.println();
        // Print the Evolution of metrics
        for(int i =0; i<values.length; i++){
            // Print the number of the iterations
            str=""+i;
            str=String.format("%1$"+COLUMN_LENGTH+"s", str);
            out.print(str+"\t");
            // Print each row of the adjacency matrix
            for(int j=0; j<values[i].length;j++){
                str=METRIC_FORMAT.format(values[i][j]);
                str=String.format("%1$"+COLUMN_LENGTH+"s", str);
                out.print(str+"\t");                
            } 
            out.println();
        } 
    }
    
}
