package simulation;
import java.util.*;

/**
 *  It represents a simulation with a multi-agent system. Several
 * agentes can be registered in the simulation. The simulation
 * is run with a given number of iterations.
 * @author Iván García-Magariño
 */
public class Simulation {
    /** List of all the agents registered for the simulation **/
    private List<Agent> agents;
    /** The iteration of the simulation **/
    private int iteration;
    /** Creates a simulation with an empty list of agents **/
    public Simulation(){
        agents = new LinkedList<Agent>();
    }
    /** Register an agent in the simulation **/
    public void register(Agent agent){
        agents.add(agent);
    }
    /** Run an iteration of the simulation by calling live
     * method of all agents.
     */
    public void live(){
        Iterator<Agent> it = agents.iterator();
        Agent agent;
        while(it.hasNext()){
            agent = it.next();
            agent.live();
        }
    }
    /** Runs the whole simulation with the left number of iterations 
     * indicated in the parameter.
     */
    public void run (int numIterations){
        for(iteration=0; iteration<numIterations; iteration++){
            live();
        }
    }
    /** Returns the number of the agents in the simulation **/
    public int getSize(){
        return agents.size();
    }
    
    /** It returns a representative string of the simulator indicating
     * the state of all the agents
     * @return representative string
     */
    public String toString(){
        String str="Simulation with the following agents:\n";
        for (Agent agent:agents){
            str+=agent+"\n";
        }
        return str;
    }

    /** Returns the list of the agents of the simulation **/
    public List<Agent> getAgents() {
        return agents;
    }

    /** It returns the current iteration of the simulation 
     * starting from zero
     * @return the current iteration.
     */
    public int getIteration() {
        return iteration;
    }
    
    

    
}
