/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package simulation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.Timer;


/**
 *  A class for make a simulation but with a timer to make the simulation slower
 * and repaint a GUI to show the animation. It also allows usert to optionally
 * save the evolution of certain metrics for each iteration.
 * @author IvanGMG
 */
public class SimulationAnimation extends Simulation{
    /** Timer for the animation **/
    private Timer timer;
    /** Waiting time for each iteration in milliseconds **/
    private int time_interval;
    /** Frame for updating after each iteration */
    private JFrame gui;
    /** For counting the number of iterations **/
    private int iteration;
    /** For nummber of iterations limit **/
    private int numIterations;
    /** For recording the evolution of some measurement values of certain 
     * metrics. Setting this attribute is optional.*/
    private MeasurementEvolution measurement=null;
    /** Observer for being notified when the simulation finishes. 
     Setting this attribute is optional**/
    private ObserverAnimation observer=null;
    
    /** Constructor with a GUI **/
    public SimulationAnimation(JFrame paramGui){
        super();
        this.gui=paramGui;   
    }
    /** Runs the whole simulation with the number of iterations indicated 
     * in the parameter in a animated simulation repainting the GUI. 
     * In case the user has set a measurement evolution, then the 
     * measurement values are recorded.
     * The other iterations are performed by the run method without  
     * parameters.
     */
    public void run (int paramNumIterations){
        this.numIterations=paramNumIterations;
        iteration=0;
        /** Creates the timer **/
        timer = new Timer(time_interval, new ActionListener (){
            public void actionPerformed(ActionEvent e) {
                 live();
                 gui.repaint();
                 if(measurement!=null){
                     measurement.recordValues();
                 }
                 run();
            }
        });
        timer.start();
    }
    /** Runs after each time the timer runs out of time **/
    public void run (){
        iteration++;
        timer.stop();
        if(iteration<numIterations){
            timer.start();
        }
        // Notfies the end of the simulation animation
        else{
            observer.updateFinishedSimulation();
        }
    }
    /** Returns the number of iteration **/
    public int getIteration(){
        return iteration;
    }
     /** Returns the limit number of iterations **/
    public int getNumIterations(){
        return numIterations;
    }
    
    
    
    /** Set the speed (iterations/second) translating it to miliseconds of the 
     * interval of each iteration.*/
    public void setSpeed(double speed){
        time_interval = (int)(1000/speed);
    }
    /** Sets a reference to the measurement value given in the parameter
     * @param measurement Object in which the records will be recorded.
     */
    public void setMeasurementEvolution(MeasurementEvolution measurement){
        this.measurement=measurement;
    }
    /** Sets the observer for notififying the end of the simulation **/
    public void setObserver(ObserverAnimation observer){
        this.observer=observer;
    }
    
}
